﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.EwidencjaVat" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Globalization" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		
<title></title>
		<script runat="server">

    static readonly int maxLines = 65;     
    static readonly int pageWidth = 80;
    static readonly int pageWidthSmall = 129;
    static readonly string longLine = new string('-',pageWidthSmall);
    
    class SumatorStawek{
			public class Suma{
				readonly public StawkaVat Stawka = null;    			
				public decimal Netto,VAT,Brutto;
				
				public Suma(StawkaVat stawka){
					this.Stawka = stawka;
				}
			}
			
			Hashtable wgStawek = new Hashtable();
			
			public void Add(ElemRozliczeniaVAT elem){
				Suma suma = (Suma)wgStawek[elem.Stawka];
				if(suma==null){
					suma = new Suma(elem.Stawka);
					wgStawek[elem.Stawka] = suma;
				}
				suma.Netto += elem.Netto.Value;
				suma.VAT += elem.VAT.Value;
				suma.Brutto += elem.Brutto.Value;								
			}
			
			public ICollection Sumy{ get{ return wgStawek.Values; } }
    }
    
    int lp;
    int lineNr;
    int pageNr;
    VATEwidencja lastEwid;
    string rowText = ""; 
    SumatorStawek sumator = null;
   Soneta.Business.View view = null;
    EleRozliczenVATT.Params p;        
    
    void OnContextLoad(Object sender, EventArgs args) {
        ///////////////////////////////////////////////
        // Inicjacja pól
        //
        p = (EleRozliczenVATT.Params)dc.Get(typeof(EleRozliczenVATT.Params)); 
        view = (Soneta.Business.View)dc.Context[typeof(Soneta.Business.View)];
        view.Sort = "Naglowek.Naglowek.DataZaewidencjonowania,Naglowek.Naglowek.NumerDokumentu,Naglowek.Naglowek";

        lastEwid = null;
        lp = 0;
        lineNr = 0;
        pageNr = 1;
        sumator = new SumatorStawek();
    }
    
     string writePieczatka(){
			CoreModule core = CoreModule.GetInstance(dc.Session);
			lineNr += 10;
			string value="";
			foreach(string s in NazwaWieleLinii().Split(new []{Environment.NewLine}, StringSplitOptions.None))
				value += s + "\n";
			value +=
				core.Config.Firma.AdresSiedziby.Linia1 + "\n" +
				core.Config.Firma.AdresSiedziby.Linia2 +	"\n" +
				"NIP: " + core.Config.Firma.Pieczątka.NIP;
			return value;
    }
    
    string writeTytul(){
		return "\n" + Center("Elementy rozliczeń VAT - wg dokumentów",80) + "\n";
    }
    
    string writeNaglowek(){
			lineNr += 10;
			string value="";
			value +=
				Center(string.Format("Typ ewidencji: {0}; ",p.Typ) + string.Format("Za okres: {0}",p.Zakres),pageWidthSmall) + "\n" + 
				Center(string.Format("Definicja: {0}; ",p.Definicja==null ? "Wszystkie" : p.Definicja.ToString()) + string.Format("Podmiot: {0}; ",p.Podmiot==null ? "Wszyscy" : p.Podmiot.ToString()) + string.Format("Korekty: {0}",p.Korekty),pageWidthSmall) + "\n" +
				Center(string.Format("Odliczenia: {0}; ",p.Odliczenia) + string.Format("Rodzaj zakupu: {0}",p.RodzajZakupu),pageWidthSmall) + "\n" +
				Center(string.Format("Rodzaj podmitu: {0}; ",p.RodzajPodmiotu) + string.Format("Status podmiotu: {0}",p.StatusPodmiotu),pageWidthSmall) + "\n\n";
			return value;
    }

    void writeRow(Row row){
        ElemRozliczeniaVAT elem = (ElemRozliczeniaVAT)row;
        sumator.Add(elem);
        
        rowText = "\n";
        if(lastEwid==null || lastEwid!=elem.Naglowek.Naglowek.Ewidencja){
					lastEwid = (VATEwidencja)elem.Naglowek.Naglowek.Ewidencja;
					lineNr++;
					rowText +=
						"|" + Left(lastEwid.NumerDokumentu,27) + 
						"|" + Center(lastEwid.DataDokumentu,10) + 						
						"|" + Left(string.Format("{0}({1}) - {2}",lastEwid.DaneKontrahenta.Nazwa,lastEwid.DaneKontrahenta.EuVAT,lastEwid.DaneKontrahenta.Adres),88) + 												
						"|\n";
        }
				
				lineNr += 2;
        rowText += 
            "|" + Right(++lp, 5) +
            "|" + Center(elem.Data, 10) +
            "|" + Center((elem.TypEwidencji==TypEwidencjiVAT.Zakup) ? elem.Rodzaj.ToString() : "-", 10) +
            "|" + Center((elem.TypEwidencji==TypEwidencjiVAT.Zakup) ? elem.Odliczenia.ToString() : "-", 10) +            
            "|" + Center(elem.Stawka, 8) +                        
            "|" + Right(elem.Netto.Value, 30) +                        
            "|" + Right(elem.VAT.Value, 17) +                                    
            "|" + Right(elem.Brutto.Value, 30) + "|";
        
        rowText += "\n" + longLine;
    }
    
    string writeSumy(){
			string value = "\n" + "Podsumowanie stawek wg VAT";
			value += "\n" + longLine;
			value += "\n" + "|" + Center("Stawka",10) + "|" + Center("Netto",41) + "|" + Center("VAT",32) + "|" + Center("Brutto",41) + "|";
			value += "\n" + longLine;			
			foreach(SumatorStawek.Suma suma in sumator.Sumy){
				value += 
					"\n" +
					"|" + Center(suma.Stawka,10) + 
					"|" + Right(suma.Netto,41) + 
					"|" + Right(suma.VAT,32) + 					
					"|" + Right(suma.Brutto,41) + "|" +
					"\n" + longLine;
			}
			return value;
    }
    
    string writePodpis(){
		return
			"\n\n" +
			string.Format("Data wydruku: {0}",Date.Today) + "\n" + 
			string.Format("Operator: {0}",dc.Session.Login.Operator) + "\n" +
			Center("--- KONIEC WYDRUKU---",pageWidthSmall);
			
    }


    private string NazwaWieleLinii()
	{
		IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false );
		return pieczątka.NazwaFormatowana;
	}
    
    string writeNumerStrony(){
		return "\n" + Right(string.Format("Strona: {0}",pageNr++),pageWidthSmall);
    }
    
    //Metody pomocnicze
    static string Center(object value, int len) {
        string ss = value.ToString();
        if (ss.Length>=len)
            return ss.Substring(0, len);
        int delta = len - ss.Length;
        int a = delta/2;
        return ss.PadRight(ss.Length+a).PadLeft(len);
    }
    
    static string Left(object value, int len) {
        string ss = value.ToString();
        if (ss.Length>len)
            return ss.Substring(0, len);
        return ss.PadRight(len);
    }
    
    static string Right(object value, int len) {
        string ss = value.ToString();
        if (ss.Length>len)
            return ss.Substring(0, len);
        return ss.PadLeft(len);
    }
    
    static string Clip(object value, int len) {
        string ss = value.ToString();
        if (ss.Length>len)
            return ss.Substring(0, len);
        return ss;
    }
    
    static void Msg(object value) {
    }

		</script>
		
	</HEAD>
	<body>
		<form id="ElementyRozliczenVAT" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" 
				TypeName="Soneta.Business.Row[],Soneta.Business"></ea:datacontext>
				<small><pre><%= writePieczatka() %></pre></small>
				<pre><%= writeTytul() %></pre>				
				<small><pre><%= writeNaglowek() %></pre><small>
				<small><pre><% foreach(Row r in view){ 
								writeRow(r);	
					  if(lineNr>=maxLines) { 
						Response.Write(writeNumerStrony());
						%></pre></small><ea:PageBreak runat="server"></ea:PageBreak><small><pre><%
					  } 
						 if(lineNr>=maxLines || lp==1) { 
								if(lp!=1)
									lineNr = 0; 
%>---------------------------------------------------------------------------------------------------------------------------------
|       Nr dokumentu        | Data dok.|                                    Podmiot                                             | 
| Lp. | Data roz.|  Rodzaj  |Odliczenia| Stawka |             Netto            |       VAT       |             Brutto           |
---------------------------------------------------------------------------------------------------------------------------------<% } 
						 Response.Write(Soneta.HTML.HtmlParser.HtmlEncode(rowText)); 
						 } 
						if((maxLines-10)<lineNr){
						Response.Write(writeNumerStrony());						
					%></pre></small><ea:PageBreak runat="server"></ea:PageBreak><small><pre><% 	
						}
						Response.Write(writeSumy());
						Response.Write(writePodpis());						
						Response.Write(writeNumerStrony()); %></pre></small>
					<ea:PageBreak runat="server"></ea:PageBreak>
		</form>
	</body>
</HTML>

